import 'package:admin_desktop/application/add_service/add_service_master_state.dart';
import 'package:admin_desktop/domain/di/dependency_manager.dart';
import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';
import '../../domain/models/data/service_data.dart';
import '../../infrastructure/services/app_helpers.dart';

class AddServiceMasterNotifier extends StateNotifier<AddServiceMasterState> {
  AddServiceMasterNotifier() : super(AddServiceMasterState());

  int _page = 0;
  int? _masterId;

  void setActive(bool? value) {
    state = state.copyWith(active: !state.active);
  }

  void clear() {
    state = state.copyWith(
      active: false,
      isLoading: false,
    );
  }

  Future<void> createService(
    BuildContext context, {
    required String price,
    required String pause,
    required String discount,
    required String interval,
    required String commissionFee,
    required int? masterId,
    required int serviceId,
    required String gender,
    ValueChanged<ServiceData?>? created,
    VoidCallback? onError,
  }) async {
    state = state.copyWith(isLoading: true);
    final response = await serviceMasterRepository.createService(
        price: num.tryParse(price) ?? 0,
        commissionFee: num.tryParse(commissionFee) ?? 0,
        discount: num.tryParse(discount) ?? 0,
        pause: int.tryParse(pause) ?? 0,
        interval: int.tryParse(interval) ?? 0,
        masterId: masterId,
        serviceId: serviceId,
        gender: gender == "male"
            ? 1
            : gender == "female"
                ? 2
                : 3);
    response.when(
      success: (data) {
        state = state.copyWith(isLoading: false);
        created?.call(data.data);
      },
      failure: (failure, status) {
        debugPrint('===> create service fail $failure');
        state = state.copyWith(isLoading: false);
        AppHelpers.errorSnackBar(context, text: failure);
        onError?.call();
      },
    );
  }

  Future<void> fetchServicesMaster({
    required BuildContext context,
    bool? isRefresh,
    RefreshController? controller,
    int? masterId,
  }) async {
    _masterId = masterId ?? _masterId;
    if (isRefresh ?? false) {
      controller?.resetNoData();
      _page = 0;
      state = state.copyWith(services: [], isLoading: true);
    }
    final res = await serviceMasterRepository.getServicesMaster(
      page: ++_page,
    );
    res.when(success: (data) {
      List<ServiceData> list = List.from(state.services);
      list.addAll(data.data ?? []);
      state = state.copyWith(isLoading: false, services: list);
      if (isRefresh ?? false) {
        controller?.refreshCompleted();
      } else if (data.data?.isEmpty ?? true) {
        controller?.loadNoData();
        return;
      }
      controller?.loadComplete();
      return;
    }, failure: (failure, status) {
      state = state.copyWith(isLoading: false);
      AppHelpers.errorSnackBar(context, text: failure);
    });
  }

  Future<void> fetchAllServices({
    required BuildContext context,
    bool? isRefresh,
    RefreshController? controller,
  }) async {
    if (isRefresh ?? false) {
      controller?.resetNoData();
      _page = 0;
      state = state.copyWith(allServices: [], isLoading: true);
    }
    final res =
        await serviceMasterRepository.getAllServicesMaster(page: ++_page);
    res.when(success: (data) {
      List<ServiceData> list = List.from(state.allServices);
      list.addAll(data.data ?? []);
      state = state.copyWith(isLoading: false, allServices: list,hasMore: list.length < (data.meta?.total ?? 0));
      if (isRefresh ?? false) {
        controller?.refreshCompleted();
        return;
      } else if (data.data?.isEmpty ?? true) {
        controller?.loadNoData();
        return;
      }
      controller?.loadComplete();
      return;
    }, failure: (failure, status) {
      state = state.copyWith(isLoading: false);
      AppHelpers.errorSnackBar(context, text: failure);
    });
  }

  Future<void> updateService(
    BuildContext context, {
    required String price,
    required String discount,
    required String commissionFee,
    required String pause,
    required String interval,
    required int serviceId,
    required int masterId,
    VoidCallback? updated,
    VoidCallback? failed,
  }) async {
    state = state.copyWith(isUpdating: true);
    final response = await serviceMasterRepository.updateService(
        price: num.tryParse(price) ?? 0,
        pause: int.tryParse(pause) ?? 0,
        interval: int.tryParse(interval) ?? 0,
        serviceId: serviceId,
        masterId: masterId,
        id: state.serviceData?.id,
        discount: int.tryParse(discount) ?? 0,
        commissionFee: num.tryParse(commissionFee) ?? 0);
    response.when(
      success: (data) {
        state = state.copyWith(isUpdating: false);
        updated?.call();
      },
      failure: (fail, status) {
        AppHelpers.errorSnackBar(
          context,
          text: fail,
        );
        state = state.copyWith(isUpdating: false);
        debugPrint('===> service update fail $fail');
        failed?.call();
      },
    );
  }

  Future<void> fetchServiceDetails({
    required BuildContext context,
    required int? id,
    required ValueChanged<ServiceData?>? onSuccess,
  }) async {
    state = state.copyWith(isLoading: true);
    final res = await serviceRepository.fetchSingleService(id);
    res.when(success: (data) {
      state = state.copyWith(
        isLoading: false,
        serviceData: data.data,
      );
      onSuccess?.call(data.data);
    }, failure: (failure, status) {
      state = state.copyWith(isLoading: false);
      AppHelpers.errorSnackBar(context, text: failure);
    });
  }

  Future<void> setDetails(ServiceData? serviceData) async {
    state = state.copyWith(serviceData: serviceData);
  }

  Future<void> createService22(
    BuildContext context, {
    required String price,
    required String pause,
    required String discount,
    required String interval,
    required String commissionFee,
    required int? masterId,
    required int serviceId,
    required String gender,
    ValueChanged<ServiceData?>? created,
    VoidCallback? onError,
  }) async {
    state = state.copyWith(isLoading: true);

    final response = await serviceMasterRepository.createService(
        price: num.tryParse(price) ?? 0,
        commissionFee: num.tryParse(commissionFee) ?? 0,
        discount: num.tryParse(discount) ?? 0,
        pause: int.tryParse(pause) ?? 0,
        interval: int.tryParse(interval) ?? 0,
        masterId: masterId,
        serviceId: serviceId,
        gender: gender == "male"
            ? 1
            : gender == "female"
                ? 2
                : 3);
    response.when(
      success: (data) {
        state = state.copyWith(isLoading: false);
        created?.call(data.data);
      },
      failure: (failure, status) {
        debugPrint('===> create service fail $failure');
        state = state.copyWith(isLoading: false);
        AppHelpers.errorSnackBar(context, text: failure);
        onError?.call();
      },
    );
  }
}
